/*
 * Created on Jul 8, 2003
 */
package Validators;

import Data.*;
import java.sql.*;

/**
 * This class is being used for validating Message data
 * 
 */
public class MessageValidator {

	private String message;

	/**
	 * This method is being used to get the validation message
	 * @return String message
	 */
	public String getMessage() {
		return message;
	}
	/**
	 * This method is being used setting validation message
	 * @param String message 
	 * @return void
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * This method is being used to validate message data
	 * @param announcementData data to be validated
	 * @return boolean true if validation successful
	 */
	public boolean validate(MessageData messageData) {

		MessageData messagedata = messageData;
		String from, to, body, subject;
		Timestamp time;

		from = messagedata.getFrom();
		to = messagedata.getTo();
		body = messagedata.getBody();
		subject = messagedata.getSubject();
		time = messagedata.getTime();

		if (to.equals("") || body.equals("") || subject.equals("")) {
			message = "Please enter subject and body for the message. ";
			return false;
		}
		if (!subject.matches("^[a-zA-Z/`/'/s/ ]{1,50}+$")) {
							message = "Subject of the message has invalid characters.";
							message += " Subject of the message has to be less than 50 characters. ";
							return false;
				}
		if (!body.matches("^[a-zA-Z/`/'/s/ ]{1,128}+$")) {
			message = "Body of the message has invalid characters.";
			message += " Body of the message has to be less than 128 characters. ";
			return false;
		}	
		return true;

	}
}
